<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;

use App\Drivers;

use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\DB;
use Auth;

class DriversController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    // Create new driver
    public function register_driver(Request $request){

        $Driver = new Drivers;

        $Driver->driver_id = $request->driver_id;
        $Driver->full_names = $request->fullname;
        $Driver->licence_no = $request->licence_no;
        $Driver->route = $request->driver_route;
        $Driver->email_addr = $request->driver_email;
        $Driver->phone_no = $request->phone_no;
        $Driver->alt_no = $request->alt_no;
        $Driver->driver_address = $request->driver_address;
        $Driver->driver_city = $request->driver_city;
        $Driver->driver_country = $request->driver_country;
        $Driver->postal_code = $request->postal_code;
        $Driver->vehicle_name = $request->veh_brand;
        $Driver->vehicle_model = $request->veh_model;
        $Driver->vehicle_year = $request->veh_year;
        $Driver->vehicle_plate = $request->reg_plate;


        $Driverinput = $request->all();



        if (empty($Driver->full_names)) {
            return "empty";
        }

        if ($Driver->save($Driverinput)) {
            
            return "success";
        }else{
            return "Something went wrong, Please try again";
        }

    }


    // List all Qoutes
    public function get_drivers(Request $request){


        $Driver = Drivers::orderBy('date_created', 'DESC')->get();

        return response()->json($Driver);

    }

    // Get Driver by ID
    public function getSingleDriver(Request $request, $driver_id){

        // ->where('status', '<>', 1)
        $details = DB::table('drivers')
                     ->select(DB::raw('*'))
                     ->where('driver_id', '=', $driver_id)
                     ->orderBy('date_created', 'DESC')
                     ->first();

        $in_transit = DB::table('qoute_details')
                     ->select(DB::raw('*'))
                     ->where('driver_id', '=', $driver_id)
                     ->where('status', '=', 4)
                     ->orderBy('destination_distance', 'ASC')
                     ->get();

        $to_pickup = DB::table('qoute_details')
                     ->select(DB::raw('*'))
                     ->where('driver_id', '=', $driver_id)
                     ->where('status', '=', 1)
                     ->orderBy('collection_distance', 'ASC')
                     ->get();

        $delivered = DB::table('qoute_details')
                     ->select(DB::raw('*'))
                     ->where('driver_id', '=', $driver_id)
                     ->where('status', '=', 2)
                     ->get();


        $driver_details = array(
                      'details'       => $details,
                      'in_transit'    => $in_transit,
                      'to_pickup'     => $to_pickup,
                      'delivered'     => $delivered,
                  );

        return response()->json($driver_details);

    }



}
